/*
	File:		ColorPenState.h

	Contains:	Utility routines to save and restore the graphics state of a grafport.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#ifndef __COLORPENSTATE__
#define __COLORPENSTATE__

#include <Quickdraw.h>

#if PRAGMA_ALIGN_SUPPORTED
#pragma options align=mac68k
#endif

struct ColorPenState
{
	Boolean			colorPort;
	RGBColor		foreColor;
	RGBColor		backColor;
	PenState		pen;
	SInt16			textMode;
	PixPatHandle	pnPixPat;
	PixPatHandle	bkPixPat;
	Pattern			bkPat;
	UInt32			fgColor;
	UInt32			bkColor;
};
typedef struct ColorPenState ColorPenState;

#ifdef __cplusplus
extern "C" {
#endif

//	NOTE: The hasColor parameter is going away! Be warned...

extern void		GetColorAndPenState( ColorPenState* state );
extern void		SetColorAndPenState( ColorPenState* state );
extern void		NormalizeColorAndPen();

#ifdef __cplusplus
}
#endif

#if PRAGMA_ALIGN_SUPPORTED
#pragma options align=reset
#endif

#endif // __COLORPENSTATE__
